<!DOCTYPE HTML>
<!--
	Strongly Typed by HTML5 UP
	html5up.net | @ajlkn
	Free for personal and commercial use under the CCA 3.0 license (html5up.net/license)
-->
<html lang="en">
	<head>
		<title><?php page_title('','[WEBSITE_TITLE]'); ?></title>
		<meta http-equiv="Content-Type" content="text/html; charset=<?php echo DEFAULT_CHARSET; ?>">
		<meta name="description" content="<?php page_description(); ?>">
		<meta name="keywords" content="<?php page_keywords(); ?>">
		<meta name="robots" content="index,follow">
		<meta name="revisit-after" content="14 days">
		<meta name="generator" content="Websitebaker">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="stylesheet" href="<?php echo TEMPLATE_DIR; ?>/assets/css/klaro.css">
		<link rel="stylesheet" href="<?php echo TEMPLATE_DIR; ?>/assets/css/main.css">
		<?php register_frontend_modfiles('css');?>
	</head>

	<body class="homepage is-preload">
		<div id="page-wrapper">

			<!-- Header -->
				<section id="header">
					<h6>&nbsp;</h6><!-- only needed for to prevent validation Erros -->
					<div class="container">

						<!-- Logo -->
							<h1 id="logo"><a href="<?= WB_URL;?>"><?php page_header(); ?></a></h1>
							<p><?php page_description(); ?></p>

						<!-- Nav -->
							<nav id="nav">
								<?php
									show_menu2(
									0,
									SM2_ROOT,
									SM2_ALL,
									SM2_ALL|SM2_PRETTY,
									'[if(id==1){<li><a class="icon solid fa-home" href="[url]"><span>[menu_title]</span></a>}][if(id==2){<li><a class="icon fa-chart-bar" href="[url]"><span>[menu_title]</span></a>}][if(id==3){<li><a class="icon solid fa-cog" href="[url]"><span>[menu_title]</span></a>}][if(id==4){<li><a class="icon solid fa-retweet" href="[url]"><span>[menu_title]</span></a>}][if(id==5){<li><a class="icon solid fa-sitemap" href="[url]"><span>[menu_title]</span></a>}][if(id==6){<li><a class="icon solid  fa-arrow-alt-circle-down" href="[url]"><span>[menu_title]</span></a>}][if(level!=0){<li><a href="[url]">[menu_title]</a>}]',
									'</li>',
									'<ul>',
									'</ul>'
									);
								?>
							</nav>

					</div>
				</section>

			<!-- Main -->
				<section id="main">
					<h6>&nbsp;</h6><!-- only needed for to prevent validation Erros -->
					<div class="container">
						<div id="content">

							<!-- Post -->
								<article class="box post">
									<h6>&nbsp;</h6><!-- only needed for to prevent validation Erros -->
									<?php page_content(); ?>
								</article>

						</div>
					</div>
				</section>

			<!-- Footer -->
				<section id="footer">
					<h6>&nbsp;</h6><!-- only needed for to prevent validation Erros -->
					<div class="container">
						<header>
							[[iSectionPicker?sid=7]]
						</header>
						<div class="row">
							<div class="col-6 col-12-medium">
								<section>
									<h6>&nbsp;</h6><!-- only needed for to prevent validation Erros -->
									[[iSectionPicker?sid=17]]
								</section>
							</div>
							<div class="col-6 col-12-medium">
								<section>
									<h6>&nbsp;</h6><!-- only needed for to prevent validation Erros -->
									<div class="row">
										<div class="col-6 col-12-small">
											<ul class="icons">
												<li class="icon solid fa-home">
													Matthias Gallas<br>
													Lindtalstraße 31<br>
													97896 Freudenberg
												</li>
												<li class="icon solid fa-phone">
													+49 (0) 1 73 / 3 93 31 69
												</li>
												<li class="icon solid fa-envelope">
													<a href="mailto:info@ruebenwurzel.de">info@ruebenwurzel.de</a>
												</li>
											</ul>
										</div>
										<div class="col-6 col-12-small">
											<ul class="icons">
												<li class="icon brands fa-instagram">
													<a href="https://www.instagram.com/matthiasgallas/">matthiasgallas</a>
												</li>
												<li class="icon brands fa-facebook-f">
													<a href="https://www.facebook.com/matthias.gallas">matthias.gallas</a>
												</li>
											</ul>
										</div>
									</div>
								</section>
							</div>
						</div>
					</div>
					<div id="copyright" class="container">
						<ul class="links">
							<li><?php page_footer(); ?></li><li>Design: <a href="https://html5up.net">HTML5 UP</a></li>
						</ul>
					</div>
				</section>

		</div>

		<!-- Scripts -->
			<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/jquery.min.js"></script>
			<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/jquery.dropotron.min.js"></script>
			<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/browser.min.js"></script>
			<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/breakpoints.min.js"></script>
			<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/util.js"></script>
			<script src="<?php echo TEMPLATE_DIR; ?>/assets/js/main.js"></script>
		
		<!-- automatically include optional WB module file frontend_body.js should be always set -->
			<?php register_frontend_modfiles_body('js'); ?>
		
		<!-- add Klaro Cookie Banner -->
		<script defer  src="<?= TEMPLATE_DIR; ?>/assets/js/config.js"></script>
		<script
			defer
			data-config="klaroConfig"
			src="<?= TEMPLATE_DIR; ?>/assets/js/klaro-no-css.js">
		</script>

	</body>
</html>